/* General includes and definitions. */
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#include <string.h>

/* Boolean constants. */
#define TRUE (0 == 0)
#define FALSE (!TRUE)

/* Portable procedure declarations. */
extern void syntax_error ();
extern void system_error (const char *action);
extern void next_tone ();
extern void check_flags (int flags);

/* Implementation-dependant procedure declarations. */
extern void monitor_locks (int poll_interval);
extern void start_tone (int pitch);
extern void stop_tone ();
extern void start_timer (int interval);
extern void stop_timer ();
extern char get_option (int argc, char **argv);
extern const char *get_operand ();

/* A portable flag bit for each lock. */
#define CAPS_FLAG 0x1
#define INSERT_FLAG 0x2
#define NUM_FLAG 0x4
#define SCROLL_FLAG 0x8

/* Program invocation option definitions. */
extern const char *character_options;
